/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.cdlib.xtf.util.StringHash;
import org.cdlib.xtf.util.Tester;

public class FastStringCache {
    private int size;
    private StringHash oldHash;
    private StringHash newHash;
    public static final Tester tester = new Tester("FastStringCache"){

        protected void testImpl() {
            StringHash.tester.test();
            FastStringCache cache = new FastStringCache(3);
            cache.put("1", "a");
            cache.put("2", "b");
            cache.put("3", "c");
            assert (cache.contains("1"));
            assert (cache.contains("2"));
            assert (cache.contains("3"));
            cache.put("4", "d");
            assert (cache.get("2").equals("b"));
            cache.put("5", "e");
            cache.put("6", "f");
            assert (!cache.contains("1"));
            assert (cache.contains("2"));
            assert (cache.contains("5"));
            assert (cache.contains("6"));
        }
    };

    public FastStringCache(int size) {
        this.size = size;
        this.clear();
    }

    public void clear() {
        this.oldHash = new StringHash(1);
        this.newHash = new StringHash(this.size);
    }

    public boolean contains(String key) {
        return this.newHash.contains(key) || this.oldHash.contains(key);
    }

    public Object get(String key) {
        Object retVal = this.newHash.get(key);
        if (retVal == null && (retVal = this.oldHash.get(key)) != null) {
            this.put(key, retVal);
        }
        return retVal;
    }

    public void put(String key, Object val) {
        if (this.newHash.size() >= this.size) {
            this.oldHash = this.newHash;
            this.newHash = new StringHash(this.size);
        }
        this.newHash.put(key, val);
    }
}

