/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.cdlib.xtf.textIndexer.tokenizer.XTFTokenizer;
import org.cdlib.xtf.util.FastStringReader;

public class FastTokenizer
extends Tokenizer {
    private char[] source;
    private int pos = 0;
    static final char fakeChar = '\u1049';
    static final String fakeWord = "\u1049";
    private DribbleReader dribbleReader;
    private Tokenizer stdTokenizer;
    private static final char[] charType = new char[65536];

    private static void setCharType(char type, char from, char to) {
        for (char i = from; i <= to; i = (char)(i + '\u0001')) {
            FastTokenizer.charType[i] = type;
        }
    }

    public FastTokenizer(FastStringReader reader) {
        super(reader);
        String str = reader.getString();
        this.source = str.toCharArray();
    }

    public Token next() throws IOException {
        int tpos;
        int tlen = this.source.length;
        int type = 0;
        for (tpos = this.pos; tpos < tlen && (type = charType[this.source[tpos]]) != 97 && type != 115; ++tpos) {
        }
        int start = tpos++;
        if (type != 115) {
            while (tpos < tlen && (type = charType[this.source[tpos]]) == 97) {
                ++tpos;
            }
        }
        this.pos = tpos;
        if (this.pos == start) {
            return null;
        }
        if (tpos >= tlen - 1 || type != 112 || charType[this.source[tpos + 1]] != 'a') {
            return new Token(new String(this.source, start, this.pos - start), start, this.pos);
        }
        if (this.dribbleReader == null) {
            this.dribbleReader = new DribbleReader();
            this.stdTokenizer = new XTFTokenizer(this.dribbleReader);
        }
        while (this.pos < this.source.length && (type = charType[this.source[this.pos]]) != 119) {
            ++this.pos;
        }
        if (!(this.source[start] != 'x' && this.source[start] != 'X' || start + 1 < this.source.length && charType[this.source[start + 1]] == 'a')) {
            this.pos = start + 1;
            return new Token("x", start, start + 1, "word");
        }
        Token t1 = this.stdTokenizer.next();
        while (!t1.termText().equals(fakeWord)) {
            t1 = this.stdTokenizer.next();
        }
        this.dribbleReader.setChars(this.source, start, this.pos);
        Token t2 = this.stdTokenizer.next();
        if (this.pos == tlen && t2.termText().equals(fakeWord)) {
            return null;
        }
        assert (!t2.termText().equals(fakeWord));
        if (t2.startOffset() - t1.startOffset() == 2) {
            assert (t2.startOffset() - t1.startOffset() == 2);
            assert (t2.termText().charAt(0) == this.source[start]);
            int tokLen = t2.endOffset() - t2.startOffset();
            this.pos = start + tokLen;
            return new Token(t2.termText(), start, this.pos, t2.type());
        }
        assert (t2.startOffset() - t1.startOffset() >= 2);
        int tokStart = start + t2.startOffset() - t1.startOffset() - 2;
        int tokLen = t2.endOffset() - t2.startOffset();
        this.pos = tokStart + tokLen;
        return new Token(t2.termText(), tokStart, this.pos, t2.type());
    }

    static {
        FastTokenizer.setCharType('a', 'A', 'Z');
        FastTokenizer.setCharType('a', 'a', 'z');
        FastTokenizer.setCharType('a', '\u00c0', '\u00d6');
        FastTokenizer.setCharType('a', '\u00d8', '\u00f6');
        FastTokenizer.setCharType('a', '\u00f8', '\u00ff');
        FastTokenizer.setCharType('a', '\u0100', '\u1fff');
        FastTokenizer.setCharType('a', '0', '9');
        FastTokenizer.setCharType('a', '\u0660', '\u0669');
        FastTokenizer.setCharType('a', '\u06f0', '\u06f9');
        FastTokenizer.setCharType('a', '\u0966', '\u096f');
        FastTokenizer.setCharType('a', '\u09e6', '\u09ef');
        FastTokenizer.setCharType('a', '\u0a66', '\u0a6f');
        FastTokenizer.setCharType('a', '\u0ae6', '\u0aef');
        FastTokenizer.setCharType('a', '\u0b66', '\u0b6f');
        FastTokenizer.setCharType('a', '\u0be7', '\u0bef');
        FastTokenizer.setCharType('a', '\u0c66', '\u0c6f');
        FastTokenizer.setCharType('a', '\u0ce6', '\u0cef');
        FastTokenizer.setCharType('a', '\u0d66', '\u0d6f');
        FastTokenizer.setCharType('a', '\u0e50', '\u0e59');
        FastTokenizer.setCharType('a', '\u0ed0', '\u0ed9');
        FastTokenizer.setCharType('a', '\u1040', '\u1049');
        FastTokenizer.charType[60395] = 97;
        FastTokenizer.charType[60957] = 97;
        FastTokenizer.charType[32] = 119;
        FastTokenizer.charType[9] = 119;
        FastTokenizer.charType[10] = 119;
        FastTokenizer.charType[13] = 119;
        FastTokenizer.charType[12] = 119;
        FastTokenizer.charType[39] = 112;
        FastTokenizer.charType[46] = 112;
        FastTokenizer.charType[38] = 112;
        FastTokenizer.charType[64] = 112;
        FastTokenizer.charType[45] = 112;
        FastTokenizer.charType[47] = 112;
        FastTokenizer.charType[44] = 112;
        FastTokenizer.charType[95] = 112;
        FastTokenizer.charType[36] = 115;
        FastTokenizer.charType[162] = 115;
        FastTokenizer.charType[163] = 115;
        FastTokenizer.charType[164] = 115;
        FastTokenizer.charType[165] = 115;
        FastTokenizer.charType[402] = 115;
        FastTokenizer.charType[8355] = 115;
        FastTokenizer.charType[8356] = 115;
        FastTokenizer.charType[8359] = 115;
        FastTokenizer.charType[8364] = 115;
        FastTokenizer.charType[188] = 115;
        FastTokenizer.charType[189] = 115;
        FastTokenizer.charType[190] = 115;
        FastTokenizer.charType[8531] = 115;
        FastTokenizer.charType[8532] = 115;
        FastTokenizer.charType[8533] = 115;
        FastTokenizer.charType[8534] = 115;
        FastTokenizer.charType[8535] = 115;
        FastTokenizer.charType[8536] = 115;
        FastTokenizer.charType[8537] = 115;
        FastTokenizer.charType[8538] = 115;
        FastTokenizer.charType[8539] = 115;
        FastTokenizer.charType[8540] = 115;
        FastTokenizer.charType[8541] = 115;
        FastTokenizer.charType[8542] = 115;
        FastTokenizer.charType[43] = 115;
        FastTokenizer.charType[8722] = 115;
        FastTokenizer.charType[61] = 115;
        FastTokenizer.charType[8800] = 115;
        FastTokenizer.charType[60] = 115;
        FastTokenizer.charType[62] = 115;
        FastTokenizer.charType[8804] = 115;
        FastTokenizer.charType[8805] = 115;
        FastTokenizer.charType[177] = 115;
        FastTokenizer.charType[215] = 115;
        FastTokenizer.charType[247] = 115;
        FastTokenizer.charType[8729] = 115;
        FastTokenizer.charType[183] = 115;
        FastTokenizer.charType[126] = 115;
        FastTokenizer.charType[94] = 115;
        FastTokenizer.charType[176] = 115;
        FastTokenizer.charType[172] = 115;
        FastTokenizer.charType[8776] = 115;
        FastTokenizer.charType[181] = 115;
        FastTokenizer.charType[8734] = 115;
        FastTokenizer.charType[8706] = 115;
        FastTokenizer.charType[8719] = 115;
        FastTokenizer.charType[960] = 115;
        FastTokenizer.charType[8747] = 115;
        FastTokenizer.charType[8486] = 115;
        FastTokenizer.charType[8730] = 115;
        FastTokenizer.charType[8710] = 115;
        FastTokenizer.charType[8721] = 115;
        FastTokenizer.charType[9674] = 115;
        FastTokenizer.charType[8494] = 115;
        FastTokenizer.charType[8242] = 115;
        FastTokenizer.charType[8243] = 115;
        FastTokenizer.charType[8470] = 115;
        FastTokenizer.charType[174] = 115;
        FastTokenizer.charType[169] = 115;
        FastTokenizer.charType[8482] = 115;
    }

    private class DribbleReader
    extends Reader {
        static final String fakeStr = " \u1049 ";
        private final char[] fakeChars = " \u1049 ".toCharArray();
        private char[] buf = this.fakeChars;
        private int pos = 0;
        private int max = this.fakeChars.length;

        private DribbleReader() {
        }

        public void close() throws IOException {
        }

        public void setChars(char[] buf, int pos, int max) {
            assert (this.pos == 0) : "should have eaten previous string";
            assert (buf != this.fakeChars);
            for (int i = pos; i < max; ++i) {
                if (buf[i] != '\u1049') continue;
                buf[i] = 4168;
            }
            this.buf = buf;
            this.pos = pos;
            this.max = max;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int avail = this.max - this.pos;
            int toRead = len > avail ? avail : len;
            System.arraycopy(this.buf, this.pos, cbuf, off, toRead);
            this.pos += toRead;
            if (this.pos == this.max) {
                this.buf = this.fakeChars;
                this.max = this.fakeChars.length;
                this.pos = 0;
            }
            return toRead;
        }
    }
}

