/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.io.IOException;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

public abstract class FileWalker {
    private File mBasePath = null;
    private boolean mContinueProcessing = true;

    public void processFiles(String baseDir, boolean subDirs) throws IOException {
        try {
            this.mBasePath = new File(Path.normalizePath(baseDir));
        }
        catch (Exception e) {
            Trace.error("*** FileWalker Exception: " + e.getClass());
            Trace.error("            With message: " + e.getMessage());
            Trace.error("");
            return;
        }
        this.mContinueProcessing = true;
        this.processFiles(this.mBasePath, subDirs);
    }

    protected abstract boolean processFile(String var1, String var2, String var3, String var4);

    private void processFiles(File theFile, boolean subDirs) throws IOException {
        if (!this.mContinueProcessing) {
            return;
        }
        if (theFile.isDirectory()) {
            String[] subFiles = theFile.list();
            for (int i = 0; i < subFiles.length; ++i) {
                File currFile = new File(theFile, subFiles[i]);
                if (currFile.isDirectory() && !subDirs) continue;
                this.processFiles(currFile, subDirs);
            }
            return;
        }
        String basePath = Path.normalizePath(this.mBasePath.getAbsolutePath());
        String fileName = theFile.getName();
        String subPath = Path.normalizeFileName(theFile.getAbsolutePath());
        subPath = subPath.substring(basePath.length(), subPath.length() - fileName.length());
        String fileExt = "";
        int fileExtIdx = fileName.lastIndexOf(46);
        if (fileExtIdx > -1) {
            fileExt = fileName.substring(fileExtIdx);
            fileName = fileName.substring(0, fileExtIdx);
        }
        if (fileName.length() == 0 && fileExt.length() != 0) {
            fileName = fileExt;
            fileExt = "";
        }
        this.mContinueProcessing = this.processFile(basePath, subPath, fileName, fileExt);
    }
}

