/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.apache.lucene.util.Prime;
import org.cdlib.xtf.util.Tester;

public class IntHash {
    private final int hashSize;
    private final Ent[] ents;
    private int curSize;
    public static final Tester tester = new Tester("IntHash"){

        protected void testImpl() {
            IntHash hash = new IntHash(5);
            hash.put(100, "hello");
            assert (hash.contains(100));
            assert (!hash.contains(111));
            assert (hash.get(100).equals("hello"));
            assert (hash.size() == 1);
            hash.put(200, "foo");
            hash.put(211, "bar");
            assert (hash.contains(100));
            assert (hash.contains(200));
            assert (hash.contains(211));
            assert (!hash.contains(111));
            assert (!hash.contains(212));
            assert (hash.size() == 3);
            assert (hash.get(100).equals("hello"));
            assert (hash.get(200).equals("foo"));
            assert (hash.get(211).equals("bar"));
        }
    };

    public IntHash(int maxSize) {
        this.hashSize = Prime.findAfter(maxSize * 2);
        this.ents = new Ent[this.hashSize];
        this.curSize = 0;
    }

    public void put(int key, Object val) {
        int bucket = key % this.hashSize;
        Ent e = this.ents[bucket];
        while (e != null) {
            if (key == e.key) {
                e.val = val;
                return;
            }
            e = e.next;
        }
        e = new Ent();
        e.key = key;
        e.val = val;
        e.next = this.ents[bucket];
        this.ents[bucket] = e;
        ++this.curSize;
    }

    public boolean contains(int key) {
        Ent e = this.ents[key % this.hashSize];
        while (e != null) {
            if (key == e.key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key) {
        Ent e = this.ents[key % this.hashSize];
        while (e != null) {
            if (key == e.key) {
                return e.val;
            }
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.curSize;
    }

    private class Ent {
        int key;
        Object val;
        Ent next;

        private Ent() {
        }
    }
}

