/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.util.Arrays;
import org.apache.lucene.util.IntList;
import org.cdlib.xtf.util.Tester;

public class IntMultiMap {
    private int[] keyLinks;
    private static final int BLOCK_SIZE = 32760;
    private Block[] blocks = new Block[]{new Block()};
    private short curBlockNum = 0;
    private Block curBlock = this.blocks[0];
    private short curBlockTop = 0;
    public static final Tester tester = new Tester("IntMultiMap"){

        protected void testImpl() {
            IntMultiMap map = new IntMultiMap(10);
            map.add(1, 10);
            map.add(2, 20);
            map.add(2, 21);
            map.add(3, 30);
            map.add(3, 31);
            map.add(3, 32);
            int pos = map.firstPos(0);
            assert (pos < 0);
            pos = map.firstPos(1);
            assert (pos >= 0);
            assert (map.getValue(pos) == 10);
            pos = map.nextPos(pos);
            assert (pos < 0);
            pos = map.firstPos(2);
            assert (pos >= 0);
            assert (map.getValue(pos) == 21);
            pos = map.nextPos(pos);
            assert (pos >= 0);
            assert (map.getValue(pos) == 20);
            pos = map.nextPos(pos);
            assert (pos < 0);
            pos = map.firstPos(3);
            assert (pos >= 0);
            assert (map.getValue(pos) == 32);
            pos = map.nextPos(pos);
            assert (pos >= 0);
            assert (map.getValue(pos) == 31);
            pos = map.nextPos(pos);
            assert (pos >= 0);
            assert (map.getValue(pos) == 30);
            pos = map.nextPos(pos);
            assert (pos < 0);
            map.reverseOrder();
            pos = map.firstPos(0);
            assert (pos < 0);
            pos = map.firstPos(1);
            assert (pos >= 0);
            assert (map.getValue(pos) == 10);
            pos = map.nextPos(pos);
            assert (pos < 0);
            pos = map.firstPos(2);
            assert (pos >= 0);
            assert (map.getValue(pos) == 20);
            pos = map.nextPos(pos);
            assert (pos >= 0);
            assert (map.getValue(pos) == 21);
            pos = map.nextPos(pos);
            assert (pos < 0);
            pos = map.firstPos(3);
            assert (pos >= 0);
            assert (map.getValue(pos) == 30);
            pos = map.nextPos(pos);
            assert (pos >= 0);
            assert (map.getValue(pos) == 31);
            pos = map.nextPos(pos);
            assert (pos >= 0);
            assert (map.getValue(pos) == 32);
            pos = map.nextPos(pos);
            assert (pos < 0);
        }
    };

    public long byteSize() {
        return (long)(this.blocks.length * 8) + (long)(this.curBlockNum + 1) * 32760L * 8L;
    }

    public IntMultiMap(int maxKey) {
        this.keyLinks = new int[maxKey];
        Arrays.fill(this.keyLinks, -1);
    }

    public void add(int key, int value) {
        if (this.curBlockTop == 32760) {
            this.curBlockNum = (short)(this.curBlockNum + 1);
            if ((this.curBlockNum & 0x8000) != 0) {
                throw new RuntimeException("Too many blocks - increase block size");
            }
            if (this.curBlockNum == this.blocks.length) {
                Block[] oldBlocks = this.blocks;
                this.blocks = new Block[this.blocks.length * 2];
                System.arraycopy(oldBlocks, 0, this.blocks, 0, oldBlocks.length);
            }
            this.curBlock = this.blocks[this.curBlockNum] = new Block();
            this.curBlockTop = 0;
        }
        this.curBlock.links[this.curBlockTop] = this.keyLinks[key];
        this.curBlock.values[this.curBlockTop] = value;
        this.keyLinks[key] = this.curBlockNum << 16 | this.curBlockTop;
        this.curBlockTop = (short)(this.curBlockTop + 1);
    }

    public void reverseOrder() {
        IntList links = new IntList();
        for (int key = 0; key < this.keyLinks.length; ++key) {
            links.clear();
            int pos = this.keyLinks[key];
            if (pos < 0) continue;
            while (pos >= 0) {
                links.add(pos);
                pos = this.blocks[pos >> 16].links[pos & Short.MAX_VALUE];
            }
            this.keyLinks[key] = pos = links.get(links.size() - 1);
            for (int i = links.size() - 2; i >= 0; --i) {
                int nextPos;
                this.blocks[pos >> 16].links[pos & Short.MAX_VALUE] = nextPos = links.get(i);
                pos = nextPos;
            }
            this.blocks[pos >> 16].links[pos & Short.MAX_VALUE] = -1;
        }
    }

    public final int firstPos(int key) {
        return this.keyLinks[key];
    }

    public final int nextPos(int prevPos) {
        return this.blocks[prevPos >> 16].links[prevPos & Short.MAX_VALUE];
    }

    public final int getValue(int pos) {
        return this.blocks[pos >> 16].values[pos & Short.MAX_VALUE];
    }

    private class Block {
        int[] values = new int[32760];
        int[] links = new int[32760];

        Block() {
            Arrays.fill(this.values, Integer.MIN_VALUE);
            Arrays.fill(this.links, -1);
        }
    }
}

