/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import java.io.RandomAccessFile;

public class LineReader {
    private static final int blockSize = 1024;
    private byte[] block = new byte[1024];
    private int length;
    private int pos = -1;
    private int blockStart = -1;
    private int blockEnd;
    private int linePos;
    private RandomAccessFile file;
    private StringBuffer buf = new StringBuffer(500);

    public LineReader(String filePath) throws IOException {
        this.file = new RandomAccessFile(filePath, "r");
        this.length = (int)this.file.length();
        this.seek(0);
    }

    private void readBlock(int startPos) throws IOException {
        this.file.seek(startPos);
        int nRead = this.file.read(this.block);
        this.blockStart = startPos;
        this.blockEnd = Math.min(this.length, startPos + nRead);
    }

    public final int length() throws IOException {
        return this.length;
    }

    public void seek(int toPos) throws IOException {
        char c;
        this.pos = toPos;
        int newStart = this.pos - this.pos % 1024;
        if (newStart != this.blockStart) {
            this.readBlock(newStart);
        }
        if ((c = this.prevChar()) != '\n' && c != '\r') {
            this.prevLine();
        } else {
            this.nextChar();
        }
    }

    private char nextChar() throws IOException {
        if (this.pos == this.blockEnd) {
            this.readBlock(this.blockEnd);
        }
        assert (this.pos >= this.blockStart && this.pos < this.blockEnd);
        return (char)(this.block[this.pos++ - this.blockStart] & 0xFF);
    }

    private char prevChar() throws IOException {
        if (this.pos == 0) {
            return '\u0000';
        }
        if (this.pos == this.blockStart) {
            this.readBlock(this.blockStart - 1024);
            this.pos = this.blockEnd;
        }
        assert (this.pos > this.blockStart && this.pos <= this.blockEnd);
        return (char)(this.block[--this.pos - this.blockStart] & 0xFF);
    }

    public String nextLine() throws IOException {
        this.buf.setLength(0);
        this.linePos = this.pos;
        char c = '\u0000';
        while (this.pos < this.length && (c = this.nextChar()) != '\n' && c != '\r') {
            this.buf.append(c);
        }
        if (this.pos < this.length) {
            char c2 = this.nextChar();
            if (c == '\n' && c2 != '\r' || c == '\r' && c2 != '\n') {
                this.prevChar();
            }
        }
        if (this.buf.length() == 0 && this.pos == this.length) {
            return null;
        }
        return this.buf.toString();
    }

    public String prevLine() throws IOException {
        this.buf.setLength(0);
        char c = '\u0000';
        while (this.pos > 0 && (c = this.prevChar()) != '\n' && c != '\r') {
        }
        if (this.pos > 0) {
            char c2 = this.prevChar();
            if (c == '\n' && c2 != '\r' || c == '\r' && c2 != '\n') {
                this.nextChar();
            }
        }
        if (this.pos == 0) {
            return null;
        }
        while (this.pos > 0 && (c = this.prevChar()) != '\n' && c != '\r') {
            this.buf.append(c);
        }
        if (c == '\n' || c == '\r') {
            this.nextChar();
        }
        this.linePos = this.pos;
        int len = this.buf.length();
        for (int i = 0; i < len / 2; ++i) {
            c = this.buf.charAt(i);
            this.buf.setCharAt(i, this.buf.charAt(len - i - 1));
            this.buf.setCharAt(len - i - 1, c);
        }
        return this.buf.toString();
    }

    public int linePos() {
        return this.linePos;
    }
}

