/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.lang.reflect.Method;

public class Normalizer {
    private static PlatformNormalizer platformNormalizer = null;

    public static String normalize(String in) {
        if (platformNormalizer == null) {
            try {
                platformNormalizer = new Jdk16Normalizer();
            }
            catch (Exception e) {
                try {
                    platformNormalizer = new Jdk15Normalizer();
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return platformNormalizer.normalize(in);
    }

    private static class Jdk15Normalizer
    implements PlatformNormalizer {
        private Method method;
        private Object mode;

        public Jdk15Normalizer() throws Exception {
            Class<?> normalizerClass = Class.forName("sun.text.Normalizer");
            Class<?> modeClass = Class.forName("sun.text.Normalizer$Mode");
            this.method = normalizerClass.getMethod("normalize", String.class, modeClass, Integer.TYPE);
            this.mode = normalizerClass.getField("COMPOSE").get(null);
        }

        public String normalize(String in) {
            try {
                return (String)this.method.invoke(null, in, this.mode, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Jdk16Normalizer
    implements PlatformNormalizer {
        private Method method;
        private Object form;

        public Jdk16Normalizer() throws Exception {
            Class<?> normalizerClass = Class.forName("java.text.Normalizer");
            Class<?> formClass = Class.forName("java.text.Normalizer$Form");
            this.method = normalizerClass.getMethod("normalize", CharSequence.class, formClass);
            this.form = formClass.getField("NFC").get(null);
        }

        public String normalize(String in) {
            try {
                return (String)this.method.invoke(null, in, this.form);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface PlatformNormalizer {
        public String normalize(String var1);
    }
}

