/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.cdlib.xtf.util.SubStoreReader;
import org.cdlib.xtf.util.SubStoreWriter;

public class PackedByteBuf {
    private byte[] bytes;
    private int pos = 0;
    private char[] strChars;
    private boolean compressTried = false;
    private boolean compressed = false;
    private int uncompLen = 0;
    private static ThreadLocal compressInfo = new ThreadLocal();
    private static final byte compressMarker = -65;
    private static final int compressLimitMin = 100;
    private static final int compressLimitMax = 65000;

    public PackedByteBuf(int initialSize) {
        this.bytes = new byte[initialSize];
    }

    public PackedByteBuf(SubStoreReader in, int len) throws IOException {
        this.bytes = new byte[len];
        in.read(this.bytes, 0, len);
        this.decompress();
    }

    public PackedByteBuf(DataInput in, int len) throws IOException {
        this.bytes = new byte[len];
        in.readFully(this.bytes, 0, len);
        this.decompress();
    }

    public PackedByteBuf(byte[] rawBytes) {
        this.setBytes(rawBytes);
    }

    public void setBytes(byte[] rawBytes) {
        this.bytes = rawBytes;
        this.reset();
        this.decompress();
    }

    private void decompress() {
        if (this.bytes.length < 3 || this.bytes[0] != -65) {
            return;
        }
        int size = this.bytes[1] & 0xFF | (this.bytes[2] & 0xFF) << 8;
        if (size == 0) {
            this.bytes[2] = -65;
            this.pos = 2;
            return;
        }
        CompressInfo info = (CompressInfo)compressInfo.get();
        if (info == null) {
            info = new CompressInfo();
            compressInfo.set(info);
        }
        if (info.inflater == null) {
            info.inflater = new Inflater(true);
        }
        byte[] outBuf = new byte[size + 5];
        info.inflater.reset();
        info.inflater.setInput(this.bytes, 3, this.bytes.length - 3);
        try {
            int resultLength = info.inflater.inflate(outBuf);
            assert (resultLength == size);
        }
        catch (DataFormatException e) {
            assert (false) : "PackedByteBuf data corrupted";
            throw new RuntimeException(e);
        }
        this.bytes = outBuf;
        this.pos = 0;
    }

    public Object clone() {
        PackedByteBuf other = new PackedByteBuf(this.pos);
        System.arraycopy(this.bytes, 0, other.bytes, 0, this.pos);
        other.pos = this.pos;
        return other;
    }

    public void writeByte(byte b) {
        this.ensureSize(1);
        this.bytes[this.pos++] = b;
    }

    public void writeBytes(byte[] b) {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int offset, int length) {
        this.ensureSize(length);
        System.arraycopy(b, offset, this.bytes, this.pos, length);
        this.pos += length;
    }

    public void writeInt(int n) {
        int shift;
        assert (n >= 0) : "Negative ints not allowed in PackedByteBuf.writeInt()";
        this.ensureSize(5);
        for (shift = 7; shift < 32 && n >> shift != 0; shift += 7) {
        }
        shift -= 7;
        while (shift > 0) {
            this.bytes[this.pos++] = (byte)(n >> shift & 0x7F | 0x80);
            shift -= 7;
        }
        this.bytes[this.pos++] = (byte)(n & 0x7F);
    }

    public void writeString(String s) {
        int i;
        if (s.length() == 0) {
            this.ensureSize(1);
            this.bytes[this.pos++] = 0;
            return;
        }
        int allBits = 0;
        for (i = 0; i < s.length(); ++i) {
            allBits |= s.charAt(i);
        }
        if (s.length() < 64 && (allBits & 0xFF) == allBits) {
            this.ensureSize(s.length() + 1);
            this.bytes[this.pos++] = (byte)s.length();
            char[] chars = s.toCharArray();
            assert (chars.length == s.length());
            for (int i2 = 0; i2 < chars.length; ++i2) {
                this.bytes[this.pos++] = (byte)(chars[i2] & 0xFF);
            }
            return;
        }
        this.writeInt(s.length() + 64);
        for (i = 0; i < s.length(); ++i) {
            this.writeInt(s.charAt(i));
        }
    }

    public void writeCharSequence(CharSequence s) {
        int i;
        if (s.length() == 0) {
            this.bytes[this.pos++] = 0;
            return;
        }
        int allBits = 0;
        for (i = 0; i < s.length(); ++i) {
            allBits |= s.charAt(i);
        }
        if (s.length() < 64 && (allBits & 0xFF) == allBits) {
            this.ensureSize(s.length() + 1);
            this.bytes[this.pos++] = (byte)s.length();
            for (i = 0; i < s.length(); ++i) {
                this.bytes[this.pos++] = (byte)s.charAt(i);
            }
            return;
        }
        this.writeInt(s.length() + 64);
        for (i = 0; i < s.length(); ++i) {
            this.writeInt(s.charAt(i));
        }
    }

    public void writeBuffer(PackedByteBuf b) {
        this.writeInt(b.length());
        this.writeBytes(b.bytes, 0, b.length());
    }

    private void ensureSize(int nBytes) {
        assert (!this.compressTried);
        if (this.pos + nBytes >= this.bytes.length) {
            byte[] newBytes = new byte[(this.pos + nBytes) * 3 / 2];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.pos);
            this.bytes = newBytes;
        }
    }

    public void reset() {
        this.pos = 0;
        this.compressTried = false;
        this.compressed = false;
    }

    private void compress() {
        int needed;
        if (this.compressTried || this.pos < 100 || this.pos > 65000) {
            return;
        }
        this.compressTried = true;
        CompressInfo info = (CompressInfo)compressInfo.get();
        if (info == null) {
            info = new CompressInfo();
            compressInfo.set(info);
        }
        if (info.deflater == null) {
            info.deflater = new Deflater(9, true);
        }
        if (info.buf.length < (needed = this.pos * 4 + 50)) {
            info.buf = new byte[needed];
        }
        info.deflater.reset();
        info.deflater.setInput(this.bytes, 0, this.pos);
        info.deflater.finish();
        int compressedDataLength = info.deflater.deflate(info.buf);
        assert (compressedDataLength != 0) : "Deflater should not need more data";
        if (compressedDataLength + 3 >= this.pos) {
            return;
        }
        this.compressed = true;
        this.uncompLen = this.pos;
        System.arraycopy(info.buf, 0, this.bytes, 0, compressedDataLength);
        this.pos = compressedDataLength;
    }

    public void compact() {
        this.compress();
        if (this.bytes.length != this.pos) {
            byte[] copy = new byte[this.pos];
            System.arraycopy(this.bytes, 0, copy, 0, this.pos);
            this.bytes = copy;
        }
    }

    public int length() {
        this.compress();
        if (!this.compressed) {
            if (this.pos > 0 && this.bytes[0] == -65) {
                return this.pos + 2;
            }
            return this.pos;
        }
        return this.pos + 3;
    }

    public void output(SubStoreWriter out) throws IOException {
        this.compress();
        this.output(out, this.pos);
    }

    public void output(DataOutput out) throws IOException {
        this.compress();
        this.output(out, this.pos);
    }

    public void output(SubStoreWriter out, int len) throws IOException {
        assert (this.pos > 0) : "Cannot output empty buffer";
        this.compress();
        if (this.compressed) {
            out.writeByte(-65);
            assert (this.uncompLen >> 16 == 0) : "Tried to compress too much data";
            out.writeByte(this.uncompLen & 0xFF);
            out.writeByte(this.uncompLen >> 8 & 0xFF);
            out.writeByte(this.bytes[0]);
            assert (this.length() == this.pos + 3);
        } else {
            out.writeByte(this.bytes[0]);
            if (this.bytes[0] == -65) {
                out.writeByte(0);
                out.writeByte(0);
                assert (this.length() == this.pos + 2);
            } else assert (this.length() == this.pos);
        }
        int nToWrite = len <= this.pos ? len : this.pos;
        out.write(this.bytes, 1, nToWrite - 1);
        if (nToWrite < len) {
            byte[] zeros = new byte[len - nToWrite];
            out.write(zeros, 0, len - nToWrite);
        }
    }

    public void output(DataOutput out, int len) throws IOException {
        assert (this.pos > 0) : "Cannot output empty buffer";
        this.compress();
        if (this.compressed) {
            out.write(-65);
            assert (this.uncompLen >> 16 == 0) : "Tried to compress too much data";
            out.write(this.uncompLen & 0xFF);
            out.write(this.uncompLen >> 8 & 0xFF);
            out.write(this.bytes[0]);
            assert (this.length() == this.pos + 3);
        } else {
            out.write(this.bytes[0]);
            if (this.bytes[0] == -65) {
                out.writeShort(0);
                assert (this.length() == this.pos + 2);
            } else assert (this.length() == this.pos);
        }
        int nToWrite = len <= this.pos ? len : this.pos;
        out.write(this.bytes, 1, nToWrite - 1);
        if (nToWrite < len) {
            byte[] zeros = new byte[len - nToWrite];
            out.write(zeros, 0, len - nToWrite);
        }
    }

    public byte readByte() {
        return this.bytes[this.pos++];
    }

    public void readBytes(byte[] bytes) {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] outBytes, int start, int length) {
        System.arraycopy(this.bytes, this.pos, outBytes, start, length);
        this.pos += length;
    }

    public void skipBytes(int num) {
        this.pos += num;
    }

    public int readInt() {
        int n;
        if (((n = this.bytes[this.pos++]) & 0x80) == 0) {
            return n;
        }
        n &= 0x7F;
        while (true) {
            byte b;
            n <<= 7;
            if (((b = this.bytes[this.pos++]) & 0x80) == 0) {
                return n | b;
            }
            n |= b & 0x7F;
        }
    }

    public void skipInt() {
        while ((this.bytes[this.pos] & 0x80) != 0) {
            ++this.pos;
        }
        ++this.pos;
    }

    public String readString() {
        int length = this.readInt();
        if (length == 0) {
            return "";
        }
        if (length < 64) {
            if (this.strChars == null || this.strChars.length < length) {
                this.strChars = new char[length];
            }
            for (int i = 0; i < length; ++i) {
                this.strChars[i] = (char)(this.bytes[this.pos++] & 0xFF);
            }
            return new String(this.strChars, 0, length);
        }
        char[] chars = new char[length -= 64];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(this.readInt() & 0xFFFF);
        }
        return new String(chars);
    }

    public void skipString() {
        int length = this.readInt();
        if (length < 64) {
            this.pos += length;
            return;
        }
        length -= 64;
        for (int i = 0; i < length; ++i) {
            this.skipInt();
        }
    }

    public PackedByteBuf readBuffer() {
        int length = this.readInt();
        PackedByteBuf buf = new PackedByteBuf(length);
        this.readBytes(buf.bytes);
        return buf;
    }

    public void skipBuffer() {
        int length = this.readInt();
        this.pos += length;
    }

    private class CompressInfo {
        Deflater deflater;
        Inflater inflater;
        byte[] buf = new byte[500];

        private CompressInfo() {
        }
    }
}

