/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.cdlib.xtf.util.Tester;

public class Path {
    public static final Tester tester = new Tester("Path"){

        protected void testImpl() throws Exception {
            String x = Path.normalizePath("c:\\tmp\\foo");
            assert (x.equals("C:/tmp/foo/"));
            x = Path.normalizeFileName("xyz/./foo.txt/");
            assert (x.equals("xyz/foo.txt"));
            x = Path.normalizeFileName("./foo/bar.txt");
            assert (x.equals("foo/bar.txt"));
            x = Path.normalize("/usr/tmp/../foo/bar.txt");
            assert (x.equals("/usr/foo/bar.txt"));
            x = Path.normalize("/usr/local/tmp/../../foo/bar/");
            assert (x.equals("/usr/foo/bar/"));
        }
    };

    public static final String normalizePath(String path) {
        StringBuffer trimPath = new StringBuffer();
        trimPath.append(path.trim());
        int len = trimPath.length();
        int lastSlash = -1;
        int lastLastSlash = -1;
        for (int i = 0; i < len; ++i) {
            assert (len == trimPath.length());
            if (trimPath.charAt(i) == '\\') {
                trimPath.setCharAt(i, '/');
            }
            if (i < len - 1 && trimPath.charAt(i + 1) == '\\') {
                trimPath.setCharAt(i + 1, '/');
            }
            if (i < len - 1 && trimPath.charAt(i) == '/' && trimPath.charAt(i + 1) == '/') {
                trimPath.deleteCharAt(i);
                --len;
                --i;
            }
            if (i < len - 1 && i == lastSlash + 1 && trimPath.charAt(i) == '.' && trimPath.charAt(i + 1) == '/') {
                trimPath.delete(i, i + 2);
                len -= 2;
            }
            if (i < len - 2 && i == lastSlash + 1 && lastLastSlash >= 0 && trimPath.charAt(lastLastSlash + 1) != '.' && trimPath.charAt(i) == '.' && trimPath.charAt(i + 1) == '.' && trimPath.charAt(i + 2) == '/') {
                trimPath.delete(lastLastSlash, i + 2);
                len -= i + 2 - lastLastSlash;
                i = lastLastSlash;
                lastSlash = trimPath.lastIndexOf("/", lastLastSlash - 1);
            }
            if (trimPath.charAt(i) != '/') continue;
            lastLastSlash = lastSlash;
            lastSlash = i;
        }
        assert (len == trimPath.length());
        if (len == 0) {
            return "";
        }
        if (len >= 3 && trimPath.charAt(1) == ':' && trimPath.charAt(2) == '/') {
            trimPath.setCharAt(0, Character.toUpperCase(trimPath.charAt(0)));
        }
        if (trimPath.charAt(len - 1) != '/') {
            trimPath.append("/");
        }
        return trimPath.toString();
    }

    public static final String normalizeFileName(String path) {
        String filename = Path.normalizePath(path);
        if (filename.length() > 0 && filename.charAt(filename.length() - 1) == '/') {
            filename = filename.substring(0, filename.length() - 1);
        }
        return filename;
    }

    public static final String normalize(String pathOrFileName) {
        if (pathOrFileName.endsWith("/") || pathOrFileName.endsWith("\\")) {
            return Path.normalizePath(pathOrFileName);
        }
        return Path.normalizeFileName(pathOrFileName);
    }

    public static final boolean createPath(String path) {
        boolean ret = false;
        File thePath = new File(Path.normalizePath(path));
        if (thePath.exists()) {
            return true;
        }
        ret = thePath.mkdirs();
        return ret;
    }

    public static final boolean deletePath(String path) {
        File f = new File(path);
        int nDeleted = 0;
        while (f.delete()) {
            ++nDeleted;
            f = f.getParentFile();
        }
        return nDeleted > 0;
    }

    public static final String calcPrefix(String longPath, String shortPath) throws IOException {
        String normShort = Path.normalizePath(new File(shortPath).getCanonicalPath());
        String normLong;
        while (!(normLong = Path.normalizePath(new File(longPath = Path.normalizePath(longPath)).getCanonicalPath())).equals(normShort)) {
            int slashPos = longPath.lastIndexOf(47, longPath.length() - 2);
            if (slashPos < 0) {
                return null;
            }
            longPath = longPath.substring(0, slashPos);
        }
        return longPath;
    }

    public static void deleteDir(File dir) throws IOException {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                Path.deleteDir(new File(dir, children[i]));
            }
        }
        if (dir.canRead() && !dir.delete()) {
            throw new IOException("Unable to delete '" + dir.toString() + "'");
        }
    }

    public static String resolveRelOrAbs(File parentDir, String childPath) {
        if (parentDir == null) {
            return Path.normalize(childPath);
        }
        return Path.normalize(Path.resolveRelOrAbs(parentDir.toString(), childPath));
    }

    public static String resolveRelOrAbs(String parentDir, String childPath) {
        childPath = Path.normalize(childPath);
        if (parentDir == null) {
            return childPath;
        }
        parentDir = Path.normalizePath(parentDir);
        if (childPath.startsWith("/")) {
            return childPath;
        }
        if (childPath.length() > 1 && childPath.charAt(1) == ':') {
            return childPath;
        }
        return parentDir + childPath;
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[(int)Math.min(src.length(), 262144L)];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

