/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.cdlib.xtf.util.Trace;

public class ThreadWatcher {
    private static HashMap beingWatched = new HashMap();
    private static Thread watcherThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginWatch(String descrip, long normalTime, long killTime) {
        Thread curThread = Thread.currentThread();
        HashMap hashMap = beingWatched;
        synchronized (hashMap) {
            if (beingWatched.containsKey(curThread)) {
                Trace.warning("Thread began operation '" + descrip + "' but never called endWatch()");
            }
            beingWatched.put(curThread, new Entry(curThread, descrip, normalTime, killTime));
            if (watcherThread == null) {
                watcherThread = new Thread(){

                    public void run() {
                        ThreadWatcher.watch();
                    }
                };
                watcherThread.setDaemon(true);
                watcherThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endWatch() {
        Thread curThread = Thread.currentThread();
        HashMap hashMap = beingWatched;
        synchronized (hashMap) {
            Entry e = (Entry)beingWatched.get(curThread);
            if (e == null) {
                Trace.warning("Thread called endWatch() without first calling beginWatch()");
                return;
            }
            if (e.runaway) {
                double secs = (double)(System.currentTimeMillis() - e.startTime) / 1000.0;
                String secStr = DecimalFormat.getInstance().format(secs);
                Trace.warning("This thread finally finished after " + secStr + " secs. Descrip: " + e.descrip);
            }
            beingWatched.remove(curThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nRunaways() {
        int count = 0;
        HashMap hashMap = beingWatched;
        synchronized (hashMap) {
            for (Entry e : beingWatched.values()) {
                if (!e.runaway) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldDie(Thread thread) {
        HashMap hashMap = beingWatched;
        synchronized (hashMap) {
            Entry e = (Entry)beingWatched.get(thread);
            if (e == null) {
                return false;
            }
            return e.kill;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void watch() {
        try {
            while (true) {
                Thread.sleep(5100L);
                HashMap hashMap = beingWatched;
                synchronized (hashMap) {
                    long curTime = System.currentTimeMillis();
                    int nRunaways = 0;
                    for (Entry e : beingWatched.values()) {
                        if (!e.kill && e.killTime > 0L && curTime - e.startTime > e.killTime) {
                            e.kill = true;
                            e.runaway = true;
                            ++nRunaways;
                            e.needPrint = true;
                            continue;
                        }
                        if (e.normalTime <= 0L || curTime < e.nextCheckTime) {
                            if (!e.runaway) continue;
                            ++nRunaways;
                            continue;
                        }
                        e.runaway = true;
                        ++nRunaways;
                        e.needPrint = true;
                    }
                    int count = 0;
                    curTime = System.currentTimeMillis();
                    for (Entry e : beingWatched.values()) {
                        if (e.runaway) {
                            ++count;
                        }
                        if (!e.needPrint) continue;
                        String id = Trace.getThreadId(e.thread);
                        if (id == null) {
                            id = "";
                        }
                        double secs = (double)(curTime - e.startTime) / 1000.0;
                        String secStr = DecimalFormat.getInstance().format(secs);
                        Trace.warning("Thread " + id + "may be " + "runaway (running " + secStr + " secs so far; runaway #" + count + " of " + nRunaways + "). " + (e.kill ? "Kill time exceeded. " : "") + "Descrip: " + e.descrip);
                        try {
                            Class<?> c = e.thread.getClass();
                            Method m = c.getMethod("getStackTrace", new Class[0]);
                            StackTraceElement[] stackTrace = (StackTraceElement[])m.invoke((Object)e.thread, new Object[0]);
                            StringBuffer buf = new StringBuffer();
                            for (int i = 0; i < stackTrace.length; ++i) {
                                buf.append("    ");
                                buf.append(stackTrace[i].toString());
                                buf.append("\n");
                            }
                            Trace.warning("...stack snapshot: \n" + buf.toString());
                        }
                        catch (Exception exc) {}
                    }
                    curTime = System.currentTimeMillis();
                    for (Entry e : beingWatched.values()) {
                        if (!e.needPrint) continue;
                        e.needPrint = false;
                        e.nextCheckTime = curTime + e.normalTime;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private static class Entry {
        Thread thread;
        String descrip;
        long startTime;
        long nextCheckTime;
        long normalTime;
        long killTime;
        boolean runaway = false;
        boolean needPrint = false;
        boolean kill = false;

        Entry(Thread t, String d, long n, long k) {
            this.thread = t;
            this.descrip = d;
            this.normalTime = n;
            this.killTime = k;
            this.startTime = System.currentTimeMillis();
            this.nextCheckTime = this.startTime + this.normalTime;
        }
    }
}

