/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.IOException;
import java.io.Writer;
import org.cdlib.xtf.util.Trace;

public class TraceWriter
extends Writer {
    private int traceLevel;
    private StringBuffer buf = new StringBuffer();

    public TraceWriter(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            char c = cbuf[i + off];
            if (c == '\n') {
                this.output(this.buf.toString());
                this.buf.setLength(0);
                continue;
            }
            this.buf.append(c);
        }
    }

    private void output(String str) {
        switch (this.traceLevel) {
            case 8: {
                Trace.debug(str);
                break;
            }
            case 4: {
                Trace.info(str);
                break;
            }
            case 2: {
                Trace.warning(str);
                break;
            }
            case 1: {
                Trace.error(str);
                break;
            }
            default: {
                assert (false) : "Unrecognized trace level";
                break;
            }
        }
    }

    public void flush() throws IOException {
        if (this.buf.length() > 0) {
            this.output(this.buf.toString());
            this.buf.setLength(0);
        }
    }

    public void close() throws IOException {
        this.flush();
    }
}

