/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.cdlib.xtf.util.FastStringCache;

public class WordMap {
    private static final int CACHE_SIZE = 5000;
    private FastStringCache cache = new FastStringCache(5000);
    private HashMap blockMap = new HashMap(100);
    private ArrayList blockHeads = new ArrayList(100);

    public WordMap(File f) throws IOException {
        this.readFile(new BufferedReader(new FileReader(f)));
    }

    public WordMap(InputStream s) throws IOException {
        this.readFile(new BufferedReader(new InputStreamReader(s)));
    }

    public synchronized String lookup(String word) {
        String val = null;
        if (this.cache.contains(word)) {
            val = (String)this.cache.get(word);
            return val;
        }
        int blockNum = Collections.binarySearch(this.blockHeads, word);
        if (blockNum < 0) {
            blockNum = -blockNum - 2;
        }
        if (blockNum < 0) {
            this.cache.put(word, null);
            return null;
        }
        String prev = (String)this.blockHeads.get(blockNum);
        String block = (String)this.blockMap.get(prev);
        int pos = 0;
        while (pos < block.length()) {
            int keyShare = block.charAt(pos) - 48;
            int barPos = block.indexOf(124, pos + 1);
            String key = prev.substring(0, keyShare) + block.substring(pos + 1, barPos);
            int end = block.indexOf(10, barPos + 1);
            int comp = key.compareTo(word);
            if (comp > 0) break;
            if (comp != 0) {
                pos = end + 1;
                if (pos < 0) break;
                prev = key;
                continue;
            }
            int valShare = block.charAt(barPos + 1) - 48;
            val = key.substring(0, valShare) + block.substring(barPos + 2, end);
            this.cache.put(word, val);
            return val;
        }
        this.cache.put(word, null);
        return null;
    }

    private void readFile(BufferedReader reader) throws IOException {
        String line;
        TreeMap<String, String> entries = new TreeMap<String, String>();
        HashMap<String, String> randomCheck = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            int barPos;
            if (line.indexOf("//") >= 0) {
                line = line.substring(0, line.indexOf("//"));
            }
            if (line.indexOf("#") >= 0) {
                line = line.substring(0, line.indexOf("#"));
            }
            if (line.indexOf(";") >= 0) {
                line = line.substring(0, line.indexOf(";"));
            }
            if ((barPos = line.indexOf(124)) < 0) continue;
            String key = line.substring(0, barPos).trim();
            String val = line.substring(barPos + 1).trim();
            if (key.length() == 0 || val.length() == 0) continue;
            entries.put(key, val);
        }
        StringBuffer buf = new StringBuffer();
        int nEntries = 0;
        String prev = "";
        String firstKey = "";
        Iterator iter = entries.entrySet().iterator();
        while (iter.hasNext()) {
            int valShare;
            int keyShare;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (firstKey.length() == 0) {
                prev = firstKey = key;
            }
            for (keyShare = 0; keyShare < key.length() && keyShare != prev.length() && key.charAt(keyShare) == prev.charAt(keyShare); ++keyShare) {
            }
            for (valShare = 0; valShare < key.length() && valShare != val.length() && key.charAt(valShare) == val.charAt(valShare); ++valShare) {
            }
            buf.append((char)(keyShare + 48) + key.substring(keyShare) + '|' + (char)(valShare + 48) + val.substring(valShare) + "\n");
            prev = key;
            if (Math.random() < 0.01) {
                randomCheck.put(key, val);
            }
            if (++nEntries != 128 && iter.hasNext()) continue;
            String block = buf.toString();
            this.blockMap.put(firstKey, block);
            this.blockHeads.add(firstKey);
            nEntries = 0;
            prev = "";
            firstKey = "";
            buf.setLength(0);
        }
        for (Map.Entry ent : randomCheck.entrySet()) {
            String result = this.lookup((String)ent.getKey());
            assert (result.equals(ent.getValue()));
        }
        assert (this.lookup("a") == null);
        assert (this.lookup("zzzzzz") == null);
        this.cache.clear();
    }
}

