/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;

public class XMLFormatter {
    private StringBuffer buf = new StringBuffer();
    public int defaultTabSize = 2;
    private static final String spaces = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ";
    private static final String newLines = "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";
    private LinkedList tagStack = new LinkedList();
    private int tabCount = 0;
    private boolean tagStartOpen = false;
    private boolean mBlankLineAfterTag = true;
    private int tabSize = this.defaultTabSize;

    public boolean blankLineAfterTag() {
        return this.mBlankLineAfterTag;
    }

    public boolean blankLineAfterTag(boolean enable) {
        boolean oldBlankLineAfterTag = this.mBlankLineAfterTag;
        this.mBlankLineAfterTag = enable;
        return oldBlankLineAfterTag;
    }

    public int tabSize() {
        return this.tabSize;
    }

    public int tabSize(int newTabSize) {
        int oldTabSize = this.tabSize;
        this.tabSize = newTabSize;
        if (this.tabSize < 0) {
            this.tabSize = 0;
        }
        if (this.tabSize > 8) {
            this.tabSize = 8;
        }
        return oldTabSize;
    }

    public void beginTag(String tagName) {
        this.closeTagStart();
        if (tagName == null || tagName.length() == 0) {
            return;
        }
        this.buf.append(spaces.substring(0, this.tabCount));
        this.buf.append("<");
        this.buf.append(tagName);
        this.tagStartOpen = true;
        this.tagStack.addLast(tagName);
        this.tab();
    }

    private void closeTagStart() {
        if (!this.tagStartOpen) {
            return;
        }
        this.buf.append(">\n");
        this.tagStartOpen = false;
    }

    public void attr(String attName, String attValue) {
        this.buf.append(" ");
        this.buf.append(attName);
        this.buf.append("=\"");
        this.buf.append(XMLFormatter.escapeText(attValue));
        this.buf.append("\"");
    }

    public void attr(String attName, int attValue) {
        this.attr(attName, Integer.toString(attValue));
    }

    public void attr(String attName, float attValue) {
        this.attr(attName, Float.toString(attValue));
    }

    public void beginTag(String tagName, String tagAtts) {
        this.closeTagStart();
        if (tagName == null || tagName.length() == 0) {
            return;
        }
        if (tagAtts == null || tagAtts.length() == 0) {
            this.beginTag(tagName);
            return;
        }
        this.buf.append(spaces.substring(0, this.tabCount));
        this.buf.append("<");
        this.buf.append(tagName);
        if (tagAtts.charAt(0) != ' ') {
            this.buf.append(" ");
        }
        this.buf.append(tagAtts);
        this.buf.append(">\n");
        this.tagStack.addLast(tagName);
        if (this.mBlankLineAfterTag) {
            this.buf.append("\n");
        }
        this.tab();
    }

    public void endTag() {
        this.closeTagStart();
        if (this.tagStack.isEmpty()) {
            return;
        }
        this.untab();
        this.buf.append(spaces.substring(0, this.tabCount));
        this.buf.append("</");
        this.buf.append((String)this.tagStack.removeLast());
        this.buf.append(">\n");
        if (this.mBlankLineAfterTag) {
            this.buf.append("\n");
        }
    }

    public void endAllTags() {
        this.closeTagStart();
        while (!this.tagStack.isEmpty()) {
            this.endTag();
        }
    }

    public void tag(String tagStr) {
        this.closeTagStart();
        this.buf.append(spaces.substring(0, this.tabCount));
        this.buf.append("<");
        this.buf.append(tagStr);
        this.buf.append("/>\n");
        if (this.mBlankLineAfterTag) {
            this.buf.append("\n");
        }
    }

    public void procInstr(String procStr) {
        this.closeTagStart();
        this.buf.append(spaces.substring(0, this.tabCount));
        this.buf.append("<?");
        this.buf.append(procStr);
        this.buf.append("?>\n");
        if (this.mBlankLineAfterTag) {
            this.buf.append("\n");
        }
    }

    public void text(String str) {
        this.closeTagStart();
        if (str == null || str.length() == 0) {
            return;
        }
        str = XMLFormatter.escapeText(str);
        this.buf.append(spaces.substring(0, this.tabCount));
        this.buf.append(str);
    }

    public void text(String str, int maxWidth) {
        this.closeTagStart();
        str = XMLFormatter.escapeText(str);
        if (str == null) {
            return;
        }
        if (maxWidth <= 0) {
            this.text(str);
            return;
        }
        while (str != null) {
            str = str.trim();
            this.buf.append(spaces.substring(0, this.tabCount));
            int spaceIdx = str.lastIndexOf(32, maxWidth);
            int crIdx = str.indexOf(13);
            int lfIdx = str.indexOf(10);
            int breakIdx = spaceIdx;
            if (crIdx > -1 && crIdx < maxWidth) {
                breakIdx = crIdx;
                if (lfIdx > -1 && lfIdx < crIdx) {
                    breakIdx = lfIdx;
                }
            } else if (lfIdx > -1 && lfIdx < maxWidth) {
                breakIdx = lfIdx;
            }
            if (breakIdx == -1) {
                this.buf.append(str);
                str = null;
                continue;
            }
            if (breakIdx == 0) {
                str = str.substring(1);
                continue;
            }
            this.buf.append(str.substring(0, breakIdx));
            this.buf.append(" \n");
            if (breakIdx < str.length() - 1) {
                str = str.substring(breakIdx + 1);
                continue;
            }
            str = null;
        }
    }

    public void rawText(String str) {
        this.closeTagStart();
        this.buf.append(str);
    }

    public void newLine() {
        this.buf.append("\n");
    }

    public void newLine(int lineCount) {
        if (lineCount > newLines.length()) {
            lineCount = newLines.length();
        }
        this.buf.append(newLines.substring(0, lineCount));
    }

    public void newLineAfterText() {
        this.newLine(this.mBlankLineAfterTag ? 2 : 1);
    }

    public int tabCount() {
        return this.tabCount;
    }

    private void tab() {
        this.tabCount += this.tabSize;
        if (this.tabCount > spaces.length()) {
            this.tabCount = spaces.length();
        }
    }

    private void untab() {
        this.tabCount = this.tabCount > this.tabSize ? (this.tabCount -= this.tabSize) : 0;
    }

    public static String escapeText(String text) {
        if (text.indexOf(38) >= 0) {
            text = text.replaceAll("&", "&amp;");
        }
        if (text.indexOf(60) >= 0) {
            text = text.replaceAll("<", "&lt;");
        }
        if (text.indexOf(62) >= 0) {
            text = text.replaceAll(">", "&gt;");
        }
        if (text.indexOf(34) >= 0) {
            text = text.replaceAll("\"", "&quot;");
        }
        return text;
    }

    public String toString() {
        return this.buf.toString();
    }

    public Source toSource() {
        return new StreamSource(new StringReader(this.buf.toString()));
    }

    public NodeInfo toNode(Configuration config) {
        String strVersion = this.buf.toString();
        StreamSource src = new StreamSource(new StringReader(strVersion));
        try {
            return TinyBuilder.build((Source)src, (Stripper)new AllElementStripper(), config);
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }
}

