/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import org.cdlib.xtf.util.Trace;
import org.xml.sax.SAXException;

public class XTFSaxonErrorListener
implements ErrorListener {
    private static ThreadLocal<ArrayList<String>> threadErrors = new ThreadLocal();

    public void warning(TransformerException exception) throws TransformerException {
        String message = "";
        if (exception.getLocator() != null) {
            message = XTFSaxonErrorListener.getLocationMessage(exception) + "\n  ";
        }
        message = message + XTFSaxonErrorListener.wordWrap(XTFSaxonErrorListener.getExpandedMessage(exception));
        Trace.warning(message);
    }

    public void error(TransformerException exception) throws TransformerException {
        String message = (exception instanceof ValidationException ? "Validation Error " : "Saxon Error ") + XTFSaxonErrorListener.getLocationMessage(exception) + ": " + XTFSaxonErrorListener.wordWrap(XTFSaxonErrorListener.getExpandedMessage(exception));
        Trace.error(message);
        ArrayList<String> list = threadErrors.get();
        if (list == null) {
            list = new ArrayList();
            threadErrors.set(list);
        }
        list.add(message);
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        this.error(exception);
        throw exception;
    }

    public static String getLocationMessage(TransformerException err) {
        SourceLocator loc = err.getLocator();
        while (loc == null) {
            if (err.getException() instanceof TransformerException) {
                err = (TransformerException)err.getException();
                loc = err.getLocator();
                continue;
            }
            if (err.getCause() instanceof TransformerException) {
                err = (TransformerException)err.getCause();
                loc = err.getLocator();
                continue;
            }
            return "";
        }
        XPathContext context = null;
        if (err instanceof DynamicError) {
            context = ((DynamicError)err).getXPathContext();
        }
        return XTFSaxonErrorListener.getLocationMessage(loc, context);
    }

    public static String[] getThreadErrors() {
        ArrayList<String> errors = threadErrors.get();
        if (errors == null) {
            return null;
        }
        return errors.toArray(new String[0]);
    }

    public static void clearThreadErrors() {
        threadErrors.set(null);
    }

    private static String getLocationMessage(SourceLocator loc, XPathContext context) {
        String locmessage = "";
        String systemId = null;
        int lineNumber = -1;
        if (loc instanceof DOMLocator) {
            locmessage = locmessage + "at " + ((DOMLocator)loc).getOriginatingNode().getNodeName() + ' ';
        } else if (loc instanceof InstructionInfoProvider) {
            String instructionName = XTFSaxonErrorListener.getInstructionName((InstructionInfoProvider)((Object)loc), context);
            if (!"".equals(instructionName)) {
                locmessage = locmessage + "at " + instructionName + ' ';
            }
            systemId = ((InstructionInfoProvider)((Object)loc)).getInstructionInfo().getSystemId();
            lineNumber = ((InstructionInfoProvider)((Object)loc)).getInstructionInfo().getLineNumber();
        }
        if (lineNumber == -1) {
            lineNumber = loc.getLineNumber();
        }
        if (lineNumber != -1) {
            locmessage = locmessage + "on line " + lineNumber + ' ';
        }
        if (loc.getColumnNumber() != -1) {
            locmessage = locmessage + "column " + loc.getColumnNumber() + ' ';
        }
        if (systemId == null) {
            systemId = loc.getSystemId();
        }
        if (systemId != null) {
            locmessage = locmessage + "of " + systemId + ':';
        }
        return locmessage;
    }

    public static String getExpandedMessage(TransformerException err) {
        String code;
        String message = "";
        if (err instanceof XPathException && (code = ((XPathException)err).getErrorCodeLocalPart()) != null) {
            message = code;
        }
        Throwable e = err;
        while (e != null) {
            String next = e.getMessage();
            if (next == null) {
                next = "";
            }
            if (!"TRaX Transform Exception".equals(next) && !message.endsWith(next)) {
                if (!"".equals(message)) {
                    message = message + ": ";
                }
                message = message + e.getMessage();
            }
            if (e instanceof TransformerException) {
                e = ((TransformerException)e).getException();
                continue;
            }
            if (!(e instanceof SAXException)) break;
            e = ((SAXException)e).getException();
        }
        return message;
    }

    private static String getInstructionName(InstructionInfoProvider inst, XPathContext context) {
        if (context == null) {
            return "";
        }
        try {
            InstructionInfo info = inst.getInstructionInfo();
            int construct = info.getConstructType();
            if (construct < 1024 && construct != 149 && construct != 181) {
                return StandardNames.getDisplayName(construct);
            }
            switch (construct) {
                case 2006: {
                    int fp = info.getObjectNameCode();
                    String name = "element constructor";
                    if (context != null) {
                        name = name + " <" + context.getController().getNamePool().getDisplayName(fp) + '>';
                    }
                    return name;
                }
                case 2007: {
                    int fp = info.getObjectNameCode();
                    String name = "attribute constructor";
                    if (context != null) {
                        name = name + ' ' + context.getController().getNamePool().getDisplayName(fp) + "=\"{...}\"";
                    }
                    return name;
                }
                case 149: {
                    int fp = info.getObjectNameCode();
                    String name = "function";
                    if (context != null) {
                        name = name + ' ' + context.getController().getNamePool().getDisplayName(fp) + "()";
                    }
                    return name;
                }
                case 181: {
                    int fp = info.getObjectNameCode();
                    String name = "template";
                    if (context != null && fp != -1) {
                        name = name + " name=\"" + context.getController().getNamePool().getDisplayName(fp) + '\"';
                    }
                    return name;
                }
            }
            return "";
        }
        catch (Exception err) {
            return "";
        }
    }

    private static String wordWrap(String message) {
        int nl = message.indexOf(10);
        if (nl < 0) {
            nl = message.length();
        }
        if (nl > 100) {
            int i;
            for (i = 90; message.charAt(i) != ' ' && i > 0; --i) {
            }
            if (i > 10) {
                return message.substring(0, i) + "\n  " + XTFSaxonErrorListener.wordWrap(message.substring(i + 1));
            }
            return message;
        }
        return message;
    }
}

