/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.xslt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.textIndexer.HTMLToString;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.xslt.XMLStubReader;
import org.xml.sax.InputSource;

public class FileUtils {
    private static HashMap dateFormatCache = new HashMap();
    private static ThreadLocal<ArrayList<File>> tempFiles = new ThreadLocal();

    public static boolean exists(XPathContext context, String filePath) {
        File file = FileUtils.resolveFile(context, filePath);
        return file.canRead();
    }

    public static String lastModified(XPathContext context, String filePath, String formatStr) {
        File file = FileUtils.resolveFile(context, filePath);
        if (!file.canRead()) {
            return null;
        }
        SimpleDateFormat fmt = FileUtils.getDateFormat(formatStr);
        String result = fmt.format(new Date(file.lastModified()));
        return result;
    }

    public static long length(XPathContext context, String filePath) {
        File file = FileUtils.resolveFile(context, filePath);
        if (!file.canRead()) {
            return -1L;
        }
        return file.length();
    }

    private static File resolveFile(XPathContext context, String filePath) {
        String stylesheetPath = context.getOrigin().getInstructionInfo().getSystemId();
        stylesheetPath = stylesheetPath.replaceFirst("^file:", "");
        stylesheetPath = stylesheetPath.replaceAll("%20", " ");
        File stylesheetDir = new File(stylesheetPath).getParentFile();
        filePath = filePath.replaceFirst("^file:", "");
        filePath = filePath.replaceAll("%20", " ");
        String resolved = Path.resolveRelOrAbs(stylesheetDir, filePath);
        return new File(resolved);
    }

    public static String resolvePath(XPathContext context, String filePath) {
        String stylesheetPath = context.getOrigin().getInstructionInfo().getSystemId();
        stylesheetPath = stylesheetPath.replaceFirst("^file:", "");
        stylesheetPath = stylesheetPath.replaceAll("%20", " ");
        File stylesheetDir = new File(stylesheetPath).getParentFile();
        filePath = filePath.replaceFirst("^file:", "");
        filePath = filePath.replaceAll("%20", " ");
        String resolved = Path.resolveRelOrAbs(stylesheetDir, filePath);
        return Path.normalize(resolved);
    }

    public static String curDateTime(XPathContext context, String formatStr) {
        SimpleDateFormat fmt = FileUtils.getDateFormat(formatStr);
        String result = fmt.format(new Date());
        return result;
    }

    private static SimpleDateFormat getDateFormat(String formatStr) {
        if (!dateFormatCache.containsKey(formatStr)) {
            dateFormatCache.put(formatStr, new SimpleDateFormat(formatStr));
        }
        return (SimpleDateFormat)dateFormatCache.get(formatStr);
    }

    public static String createTempFile(XPathContext context, String prefix, String suffix) throws IOException {
        File out = File.createTempFile(prefix, suffix);
        out.delete();
        ArrayList<File> files = tempFiles.get();
        if (files == null) {
            files = new ArrayList();
            tempFiles.set(files);
        }
        tempFiles.get().add(out);
        return out.getAbsolutePath();
    }

    public static void deleteTempFiles() {
        ArrayList<File> files = tempFiles.get();
        if (files != null) {
            for (File f : files) {
                if (!f.delete()) continue;
                files.remove(f);
            }
        }
    }

    public static DocumentInfo readXMLStub(XPathContext context, String filePath) throws IOException, XPathException {
        File file = FileUtils.resolveFile(context, filePath);
        if (!file.canRead()) {
            throw new IOException("Cannot read file '" + file.toString() + "'");
        }
        XMLStubReader xmlReader = new XMLStubReader();
        BufferedInputStream bufStream = new BufferedInputStream(new FileInputStream(file));
        InputSource inputSrc = new InputSource(bufStream);
        inputSrc.setSystemId(file.toURI().toString());
        SAXSource saxSrc = new SAXSource(xmlReader, inputSrc);
        DocumentInfo doc = context.getConfiguration().buildDocument(saxSrc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentInfo readHTMLPage(XPathContext context, String urlStr) throws IOException, XPathException {
        String pageStr;
        InputStream inStream = null;
        try {
            URL url = new URL(urlStr);
            URLConnection connection = url.openConnection();
            inStream = connection.getInputStream();
            pageStr = HTMLToString.convert(inStream);
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        DocumentInfo doc = context.getConfiguration().buildDocument(new StreamSource(new StringReader(pageStr), urlStr));
        return doc;
    }
}

