/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.xslt;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class Session {
    public static boolean isEnabled(XPathContext context) {
        return TextServlet.getCurServlet().isSessionTrackingEnabled();
    }

    public static Value getData(XPathContext context, String name) throws XPathException {
        HttpServletRequest req = TextServlet.getCurRequest();
        HttpSession session = req.getSession(false);
        if (session == null) {
            return null;
        }
        String val = (String)session.getAttribute(name);
        if (val == null) {
            return null;
        }
        return Session.getValue(context, val);
    }

    public static void setData(XPathContext context, String name, Value value) throws XPathException {
        Session.setData(context, name, Session.getString(context, value));
    }

    public static void setData(XPathContext context, String name, String value) {
        if (!TextServlet.getCurServlet().isSessionTrackingEnabled()) {
            throw new RuntimeException("Error: session tracking must be enabled in servlet config file before storing session data");
        }
        HttpServletRequest req = TextServlet.getCurRequest();
        HttpSession session = req.getSession(true);
        String oldVal = (String)session.getAttribute(name);
        if (!value.equals(oldVal)) {
            session.setAttribute(name, (Object)value);
        }
    }

    public static String encodeURL(XPathContext context, String origURL) {
        HttpServletResponse res = TextServlet.getCurResponse();
        String mappedURL = res.encodeURL(origURL);
        return mappedURL;
    }

    public static String getID() {
        if (!TextServlet.getCurServlet().isSessionTrackingEnabled()) {
            throw new RuntimeException("Error: session tracking must be enabled in servlet config file before getting session ID");
        }
        HttpServletRequest req = TextServlet.getCurRequest();
        HttpSession session = req.getSession(true);
        return session.getId();
    }

    public static boolean noCookie() {
        if (!TextServlet.getCurServlet().isSessionTrackingEnabled()) {
            return false;
        }
        HttpServletRequest req = TextServlet.getCurRequest();
        return !req.isRequestedSessionIdFromCookie();
    }

    public static String getString(XPathContext context, Value value) throws XPathException {
        if (value instanceof StringValue) {
            return value.getStringValue();
        }
        try {
            Item kid;
            NodeInfo node = (NodeInfo)value.convertToJava(NodeInfo.class, context);
            int nElements = 0;
            AxisIterator iter = node.iterateAxis((byte)3);
            while ((kid = iter.next()) != null) {
                if (!(kid instanceof NodeInfo) || ((NodeInfo)kid).getNodeKind() != 1) continue;
                ++nElements;
            }
            if (nElements == 0) {
                return value.toString();
            }
            if (nElements > 1) {
                DynamicError err = new DynamicError("Error converting XML to string: there must be exactly one root element");
                err.setXPathContext(context);
                throw err;
            }
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            ((TransformerFactory)factory).setAttribute("http://saxon.sf.net/feature/namePool", node.getNamePool());
            Transformer trans = ((TransformerFactory)factory).newTransformer();
            Properties props = trans.getOutputProperties();
            props.put("indent", "yes");
            props.put("method", "xml");
            trans.setOutputProperties(props);
            if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
                trans.setErrorListener(new XTFSaxonErrorListener());
            }
            trans.transform(node, streamResult);
            String ret = writer.getBuffer().toString();
            return ret;
        }
        catch (Exception e) {
            DynamicError err = new DynamicError("Exception occurred converting XML to string: " + e);
            err.setXPathContext(context);
            throw err;
        }
    }

    private static Value getValue(XPathContext context, String str) throws XPathException {
        int idx = str.indexOf("<?xml");
        if (idx < 0 || idx > 10) {
            return new StringValue(str);
        }
        StreamSource src = new StreamSource(new StringReader(str));
        NodeInfo doc = TinyBuilder.build((Source)src, (Stripper)new AllElementStripper(), context.getController().getConfiguration());
        return new SingletonNode(doc);
    }
}

