/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.zing;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import net.sf.saxon.om.NodeInfo;
import org.cdlib.xtf.crossQuery.CrossQuery;
import org.cdlib.xtf.crossQuery.QueryRoute;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.util.AttribList;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.XMLWriter;
import org.cdlib.xtf.zing.SRUConfig;

public class SRU
extends CrossQuery {
    public String getConfigName() {
        return "conf/sru.conf";
    }

    protected TextConfig readConfig(String configPath) {
        this.config = new SRUConfig(this, configPath);
        return this.config;
    }

    public TextConfig getConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "SRU servlet";
    }

    protected void apply(AttribList attribs, HttpServletRequest req, HttpServletResponse res) throws Exception {
        long startTime = System.currentTimeMillis();
        res.setContentType("text/xml");
        QueryRoute route = QueryRoute.createDefault(this.config.queryParserSheet);
        route.tokenizerMap.put("query", "CQL");
        QueryRequest queryReq = this.runQueryParser(req, res, route, attribs);
        if (queryReq == null) {
            return;
        }
        QueryProcessor proc = SRU.createQueryProcessor();
        QueryResult result = proc.processRequest(queryReq);
        this.formatHits("SRUResult", req, res, attribs, queryReq, result, startTime);
    }

    protected boolean shuntQueryReq(HttpServletRequest req, HttpServletResponse res, Source queryReqDoc) throws IOException {
        EasyNode node = new EasyNode((NodeInfo)queryReqDoc);
        if (this.directOutput(node, "diagnostics", res)) {
            return true;
        }
        if (this.directOutput(node, "explainResponse", res)) {
            return true;
        }
        return super.shuntQueryReq(req, res, queryReqDoc);
    }

    protected String stepSetup(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String stepStr = super.stepSetup(req, res);
        if (stepStr != null) {
            stepStr = stepStr.replaceAll("crossQuery", "SRU");
            String step = req.getParameter("debugStep");
            if (step.equals("2a")) {
                stepStr = stepStr.replaceAll("Next,", "Note that the 'query' parameter has been parsed as CQL. Next,");
            }
            stepStr = stepStr.replaceAll("final HTML", "final SRW-formatted XML");
            stepStr = stepStr.replaceAll("XML page", "XML result");
        }
        return stepStr;
    }

    private boolean directOutput(EasyNode node, String name, HttpServletResponse res) throws IOException {
        if (name.equals(node.name())) {
            String strVal = XMLWriter.toString(node);
            res.getWriter().print(strVal);
            return true;
        }
        for (int i = 0; i < node.nChildren(); ++i) {
            if (!this.directOutput(node.child(i), name, res)) continue;
            return true;
        }
        return false;
    }
}

